"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserAuthServiceFactory = void 0;
const auth_service_1 = require("../../../../modules/auth/auth.service");
const user_auth_adaptor_interface_1 = require("../../../../modules/user/interfaces/user.auth.adaptor.interface");
const user_entity_1 = require("../../../../modules/user/user.entity");
/**
 * Specific factory for creating AuthService for User
 */
class UserAuthServiceFactory {
    /**
     * Creates an instance of AuthService configured for User
     * @param userRepository - User repository
     * @returns AuthService instance for User
     */
    static create(userRepository) {
        // Adapts the User repository to work with IUserAuthAdapter
        const repository = {
            findById: (id) => __awaiter(this, void 0, void 0, function* () {
                const user = yield userRepository.findUserById(id);
                return user ? (0, user_auth_adaptor_interface_1.adaptUserForAuth)(user) : null;
            }),
            findByEmail: (email) => __awaiter(this, void 0, void 0, function* () {
                const user = yield userRepository.findUserByEmail(email);
                return user ? (0, user_auth_adaptor_interface_1.adaptUserForAuth)(user) : null;
            }),
            create: (params) => __awaiter(this, void 0, void 0, function* () {
                const user = yield userRepository.createUser(params);
                return (0, user_auth_adaptor_interface_1.adaptUserForAuth)(user);
            }),
            update: (id, params) => __awaiter(this, void 0, void 0, function* () {
                const user = yield userRepository.updateUserById(id, params);
                return user ? (0, user_auth_adaptor_interface_1.adaptUserForAuth)(user) : null;
            })
        };
        const entity = (params) => {
            const userData = {
                name: params.name || "",
                email: params.email,
                password: params.password,
                roles: [] // Set a default value for creation
            };
            const validatedUser = new user_entity_1.User(userData);
            return (0, user_auth_adaptor_interface_1.adaptUserForAuth)(validatedUser.getData());
        };
        return new auth_service_1.AuthService({ repository, entity });
    }
}
exports.UserAuthServiceFactory = UserAuthServiceFactory;
