"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserControllerFactory = void 0;
const user_controller_1 = require("../../../modules/user/user.controller");
const user_schema_1 = require("../../schemas/user.schema");
/**
 * Factory class to create UserController instances.
 */
class UserControllerFactory {
    /**
     * Create and return a new UserController instance
     * @returns UserController instance
     */
    static create(userService) {
        return new user_controller_1.UserController(userService, user_schema_1.userSchemas);
    }
}
exports.UserControllerFactory = UserControllerFactory;
