"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserRouterFactory = void 0;
const user_router_1 = require("../../routes/user.router");
/**
 * Factory class to create UserRouter instances.
 */
class UserRouterFactory {
    /**
     * Create and return a new UserRouter instance
     * @returns UserRouter instance
     */
    static create(controller, authRouter, classesRouter, authMiddleware, permissionsMiddleware) {
        return new user_router_1.UserRouter(controller, authRouter, classesRouter, authMiddleware, permissionsMiddleware);
    }
}
exports.UserRouterFactory = UserRouterFactory;
