"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserServiceFactory = void 0;
const user_service_1 = require("../../../modules/user/user.service");
/**
 * Factory class to create UserService instances.
 */
class UserServiceFactory {
    /**
     * Create and return a new UserService instance
     * @returns UserService instance
     */
    static create(repo) {
        return new user_service_1.UserService({
            userRepository: repo
        });
    }
}
exports.UserServiceFactory = UserServiceFactory;
