"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClassRouter = void 0;
const express_1 = require("express");
/**
 * Router class for class endpoints.
 * Maps HTTP routes to ClassController methods.
 */
class ClassRouter {
    constructor(controller) {
        this.path = '/app/classes';
        this.controller = controller;
        this.router = (0, express_1.Router)();
        this.initRoutes();
    }
    /**
     * Initializes all routes for the class controller
     * Maps endpoints to controller methods
     */
    initRoutes() {
        /**
         * POST /class - Creates a new class
         */
        this.router.post('/', this.controller.createClass);
        /**
         * GET /class - Lists all classs
         */
        this.router.get('/', this.controller.listClasses);
        /**
         * GET /class/:id - Finds a class by ID
         */
        this.router.get('/:id', this.controller.getClassById);
        /**
         * PUT /class/:id - Updates a class by ID
         */
        this.router.put('/:id', this.controller.updateClass);
        /**
         * DELETE /class/:id - Deletes a class by ID
         */
        this.router.delete('/:id', this.controller.deleteClass);
    }
    /**
     * Get the router with all routes
     * @returns Express Router instance
     */
    getRoutes() {
        return this.router;
    }
}
exports.ClassRouter = ClassRouter;
