"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.zipCodeValidation = void 0;
const zod_1 = __importDefault(require("zod"));
/**
 * Utility function to validate Brazilian ZIP code (CEP)
 * Checks if the cleaned string (only digits) has exactly 8 characters.
 */
exports.zipCodeValidation = zod_1.default
    .string("ZIP code is required")
    .trim()
    .min(1, { message: "ZIP code cannot be empty." })
    .refine((cep) => {
    const cleaned = cep.replace(/\D/g, '');
    return cleaned.length === 8;
}, {
    message: 'Provide a valid Brazilian ZIP code (8 digits).',
});
