"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.cnpjValidation = void 0;
const zod_1 = __importDefault(require("zod"));
exports.cnpjValidation = zod_1.default
    .string()
    .trim()
    .length(18)
    .refine((val) => {
    if (!val)
        return false;
    const cleaned = val.replace(/[^\d]+/g, '');
    if (cleaned.length !== 14)
        return false;
    if (/^(\d)\1+$/.test(cleaned))
        return false;
    const calcDV = (cnpjArr, length) => {
        const weights = length === 12
            ? [5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2]
            : [6, 5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2];
        const sum = weights.reduce((acc, weight, i) => acc + cnpjArr[i] * weight, 0);
        const rest = sum % 11;
        return rest < 2 ? 0 : 11 - rest;
    };
    const cnpjDigits = cleaned.split('').map(Number);
    const dv1 = calcDV(cnpjDigits, 12);
    const dv2 = calcDV(cnpjDigits, 13);
    return dv1 === cnpjDigits[12] && dv2 === cnpjDigits[13];
}, 'Invalid CNPJ format');
