"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.dateValidation = void 0;
const zod_1 = __importDefault(require("zod"));
const refineDate = (val) => !isNaN(new Date(val).getTime()) && new Date(val).toISOString() === val;
const regexISO8601 = /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}\.\d{3}Z$/;
exports.dateValidation = {
    isoDateSchema: zod_1.default
        .string()
        .regex(regexISO8601, "Invalid ISO 8601 date format")
        .refine(refineDate, {
        message: "Invalid date value or format mismatch",
    }),
    dateObjectSchema: zod_1.default
        .instanceof(Date, { message: "Invalid Date object" }),
    optionalIsoDateSchema: zod_1.default
        .string()
        .regex(regexISO8601, "Invalid ISO 8601 date format")
        .refine(refineDate, {
        message: "Invalid date value or format mismatch",
    }),
    optionalDateObjectSchema: zod_1.default
        .instanceof(Date, { message: "Invalid Date object" })
        .optional(),
};
