"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.objectIdArraySchema = exports.idArraySchema = exports.idSchema = exports.uuidSchema = exports.objectIdSchema = void 0;
const zod_1 = require("zod");
const objectIdRegex = /^[a-fA-F0-9]{24}$/;
const uuidRegex = /^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/i;
/**
 * Validates MongoDB ObjectId (24 hex chars)
 */
exports.objectIdSchema = zod_1.z
    .string()
    .trim()
    .refine((val) => objectIdRegex.test(val), {
    message: 'The ID is in an invalid format',
});
/**
 * Validates UUID (versions 1-5)
 */
exports.uuidSchema = zod_1.z
    .string()
    .trim()
    .refine((val) => uuidRegex.test(val), {
    message: 'The ID is in an invalid format',
});
/**
 * Generic ID schema accepting either a Mongo ObjectId or a UUID.
 */
exports.idSchema = zod_1.z.union([exports.objectIdSchema, exports.uuidSchema]);
exports.idArraySchema = zod_1.z.array(exports.idSchema).nonempty('Provide at least one valid ID');
exports.objectIdArraySchema = zod_1.z.array(exports.objectIdSchema).nonempty('Provide at least one valid ID');
