"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.passwordValidation = void 0;
const zod_1 = __importDefault(require("zod"));
exports.passwordValidation = zod_1.default
    .string()
    .min(8, 'Password must be at least 8 characters long.')
    .regex(/[A-Z]/, 'Password must include at least one uppercase letter.')
    .regex(/[a-z]/, 'Password must include at least one lowercase letter.')
    .regex(/\d/, 'Password must include at least one number.')
    .regex(/[\W_]/, 'Password must include at least one special character.');
