"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.telephoneValidation = void 0;
const zod_1 = __importDefault(require("zod"));
exports.telephoneValidation = zod_1.default
    .string()
    .trim()
    .refine((tel) => {
    const cleaned = tel.replace(/\D/g, '');
    return cleaned.length >= 10 && cleaned.length <= 11;
}, 'Provide a valid telephone number (10 or 11 digits)');
