"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.uuidV7ArraySchema = exports.uuidV7Schema = void 0;
const uuid_1 = require("uuid");
const zod_1 = require("zod");
const uuidV7Regex = /^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-7[0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}$/;
/**
 * Validate if string is uuidv7
 */
function isUUIDv7(value) {
    return (uuidV7Regex.test(value) &&
        (0, uuid_1.validate)(value) &&
        (0, uuid_1.version)(value) === 7);
}
/**
 * Schema Zod que valida UUIDv7 individuais.
 */
exports.uuidV7Schema = zod_1.z
    .string()
    .trim()
    .refine(isUUIDv7, {
    message: 'The ID is in an invalid format',
});
/**
 * Schema Zod que valida arrays de UUIDv7.
 */
exports.uuidV7ArraySchema = zod_1.z
    .array(exports.uuidV7Schema)
    .nonempty('Provide at least one valid ID');
