"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthController = void 0;
/**
 * Generic authentication controller that can work with any authenticatable entity
 * @template T - Type of entity that extends IAuthenticatableEntity
 * @template R - Type of registration parameters that extends IRegisterParams
 */
class AuthController {
    constructor(authService, authSchemas) {
        /**
         * Registers a new entity
         */
        this.register = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { body } = this.authSchemas.register.parse(req);
            const content = yield this.authService.register(body);
            res.status(201).json({ message: 'Registered successfully', content });
        });
        /**
         * Logs in an entity
         */
        this.login = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { body } = this.authSchemas.login.parse(req);
            const token = yield this.authService.login(body);
            res.status(200).json({ message: 'Login successfully', token });
        });
        /**
         * View profile
         */
        this.viewProfile = (req, res) => __awaiter(this, void 0, void 0, function* () {
            var _a;
            const user = yield this.authService.getProfile(`${(_a = req.user) === null || _a === void 0 ? void 0 : _a.id}`);
            res.status(200).json(user);
        });
        /**
         * Edit profile
         */
        this.editProfile = (req, res) => __awaiter(this, void 0, void 0, function* () {
            var _a;
            const { body } = this.authSchemas.update.parse(req);
            const id = `${(_a = req.user) === null || _a === void 0 ? void 0 : _a.id}`;
            const user = yield this.authService.updateProfile({
                id,
                data: body,
            });
            res.status(200).json({ message: 'Profile updated successfully', user });
        });
        /**
         * Requests password reset
         */
        this.forgotPassword = (req, res) => __awaiter(this, void 0, void 0, function* () {
            var _a;
            const { body } = this.authSchemas.forgotPassword.parse(req);
            const user = yield this.authService.forgotPassword(body.email);
            res.status(200).json({
                message: 'Password reset code sent to email',
                expires_at: ((_a = user.password_reset) === null || _a === void 0 ? void 0 : _a.expires_at) || '',
            });
        });
        /**
         * Resets password using the code sent by email
         */
        this.resetPassword = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { body } = this.authSchemas.resetPassword.parse(req);
            const { code, email, newPassword } = body;
            const user = yield this.authService.resetPassword(code, email, newPassword);
            res.status(200).json({ message: 'Password reset successfully', user });
        });
        this.authService = authService;
        this.authSchemas = authSchemas;
    }
}
exports.AuthController = AuthController;
