"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CategoryController = void 0;
/**
 * Controller responsible for handling category-related HTTP requests.
 * Provides endpoints for creating, retrieving, updating, and deleting categorys.
 */
class CategoryController {
    constructor(service, schemas) {
        /**
         * Creates a new category
         */
        this.createCategory = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { body } = this.schemas.createCategory.parse(req);
            const { name, description } = body;
            const category = yield this.service.createCategory({
                name,
                description: description || "",
            });
            res.status(201).json({ message: "Category created successfully", category });
        });
        /**
         * Finds a category by ID
         */
        this.getCategoryById = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { params } = this.schemas.getCategoryById.parse(req);
            const { id } = params;
            const category = yield this.service.getCategoryById(id);
            res.status(200).json(category);
        });
        /**
         * Lists all categorys
         */
        this.listCategories = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { filter } = req.body;
            const categorys = yield this.service.listCategories(filter);
            res.status(200).json(categorys);
        });
        /**
         * Updates a category by ID
         */
        this.updateCategory = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { params, body } = this.schemas.updateCategory.parse(req);
            const category = yield this.service.updateCategoryById({
                id: params.id,
                data: body
            });
            res.status(200).json({ message: "Category updated successfully", category });
        });
        /**
         * Deletes a category by ID
         */
        this.deleteCategory = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { params } = this.schemas.getCategoryById.parse(req);
            const category = yield this.service.deleteCategoryById(params.id);
            res.status(200).json({ message: "Category deleted successfully", category });
        });
        this.service = service;
        this.schemas = schemas;
    }
}
exports.CategoryController = CategoryController;
