"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Category = void 0;
class Category {
    constructor(category) {
        Category.validateRequiredFields(category);
        this.name = category.name;
        this.description = category.description;
    }
    static validateRequiredFields(category) {
        const fields = [
            'name',
            'description',
        ];
        for (const field of fields) {
            if (!category[field]) {
                throw new AppError(`Missing required field: ${field}`, 400);
            }
        }
    }
}
exports.Category = Category;
