"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CategoryService = void 0;
const category_entity_1 = require("./category.entity");
/**
 * Service responsible for business logic related to Categorys.
 * Handles creation, retrieval, update, and deletion of categorys.
 */
class CategoryService {
    constructor({ repository }) {
        /**
         * Creates a new category
         * @param category - Data for category creation
         * @returns The created category
         */
        this.createCategory = (category) => __awaiter(this, void 0, void 0, function* () {
            const newCategory = new category_entity_1.Category(category);
            const exist = yield this.repository.findCategoryByName(category.name);
            if (exist)
                throw new AppError('Category with name alreay exist', 400);
            return yield this.repository.createCategory(newCategory);
        });
        /**
         * Finds a category by ID
         * @param id - Category ID
         * @returns The found category or throws error if not found
         */
        this.getCategoryById = (id) => __awaiter(this, void 0, void 0, function* () {
            const category = yield this.repository.findCategoryById(id);
            if (!category)
                throw new AppError('Category not found', 404);
            return category;
        });
        /**
         * Lists categorys according to filter
         * @param filter - Search filter
         * @returns Array of found categorys
         */
        this.listCategories = (...args_1) => __awaiter(this, [...args_1], void 0, function* (filter = {}) {
            /*
             * Correctly configure the filter
            */
            return yield this.repository.listCategories(filter);
        });
        /**
         * Updates a category by ID
         * @param params - Update parameters (id and data)
         * @returns The updated category
         */
        this.updateCategoryById = (params) => __awaiter(this, void 0, void 0, function* () {
            const oldCategory = yield this.repository.findCategoryById(params.id);
            if (!oldCategory)
                throw new AppError('Category not found', 404);
            const category = new category_entity_1.Category(Object.assign(Object.assign({}, oldCategory), params.data));
            if (params.data.name) {
                const exist = yield this.repository.findCategoryByName(params.data.name);
                if (exist)
                    throw new AppError('Category with name already exist', 400);
            }
            return yield this.repository.updateCategoryById(params.id, category);
        });
        /**
         * Deletes a category by ID
         * @param id - Category ID
         * @returns The deleted category
         */
        this.deleteCategoryById = (id) => __awaiter(this, void 0, void 0, function* () {
            const category = yield this.repository.findCategoryById(id);
            if (!category)
                throw new AppError('Category not found', 404);
            return yield this.repository.deleteCategoryById(id);
        });
        this.repository = repository;
    }
}
exports.CategoryService = CategoryService;
