"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClassController = void 0;
/**
 * Controller responsible for handling class-related HTTP requests.
 * Provides endpoints for creating, retrieving, updating, and deleting classs.
 */
class ClassController {
    constructor(service, schemas) {
        /**
         * Creates a new class
         */
        this.createClass = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { body } = this.schemas.createClass.parse(req);
            const classData = yield this.service.createClass(body);
            res.status(201).json({ message: "Class created successfully", class: classData });
        });
        /**
         * Finds a class by ID
         */
        this.getClassById = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { params } = this.schemas.getClassById.parse(req);
            const classData = yield this.service.getClassById(params.id);
            res.status(200).json({ class: classData });
        });
        /**
         * Lists all classs
         */
        this.listClasses = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { query } = this.schemas.getClasses.parse(req);
            const classs = yield this.service.listClasses(query);
            res.status(200).json(classs);
        });
        /**
         * Updates a class by ID
         */
        this.updateClass = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { body, params } = this.schemas.updateClass.parse(req);
            const classData = yield this.service.updateClassById({
                id: params.id,
                data: body,
            });
            res.status(200).json({ message: "Class updated successfully", class: classData });
        });
        /**
         * Deletes a class by ID
         */
        this.deleteClass = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { params } = this.schemas.deleteClass.parse(req);
            const classData = yield this.service.deleteClassById(params.id);
            res.status(200).json({ message: "Class deleted successfully", class: classData });
        });
        this.service = service;
        this.schemas = schemas;
    }
}
exports.ClassController = ClassController;
