"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Class = void 0;
class Class {
    constructor(classData) {
        Class.validateRequiredFields(classData);
        Class.validateInformation(classData);
        this.data = classData;
    }
    getData() {
        return this.data;
    }
    static validateRequiredFields(classData) {
        const fields = [
            'main_student_id',
            'teacher_id',
            'topic_id',
            'start_time',
            'end_time',
            'type',
            'status',
            'payment_status',
        ];
        for (const field of fields) {
            if (!classData[field]) {
                throw new AppError(`Missing required field: ${field}`, 400);
            }
        }
    }
    static validateInformation(classData) {
        const startTime = new Date(classData.start_time);
        const endTime = new Date(classData.end_time);
        if (startTime >= endTime) {
            throw new AppError("Invalid start or end times", 400);
        }
        if (![
            "individual",
            "group"
        ]
            .includes(classData.type)) {
            throw new AppError("The type of class should be individual or group", 400);
        }
        if (![
            "scheduled",
            "canceled",
            "completed"
        ]
            .includes(classData.status)) {
            throw new AppError("Invalid class status", 400);
        }
        if (![
            "pending",
            "paid",
            "refunded"
        ]
            .includes(classData.payment_status)) {
            throw new AppError("Invalid class payment status", 400);
        }
    }
}
exports.Class = Class;
