"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DisciplineController = void 0;
/**
 * Controller responsible for handling discipline-related HTTP requests.
 * Provides endpoints for creating, retrieving, updating, and deleting disciplines.
 */
class DisciplineController {
    constructor(service, schemas) {
        /**
         * Creates a new discipline
         */
        this.createDiscipline = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { body } = this.schemas.createDiscipline.parse(req);
            const { name, description, category_id } = body;
            const discipline = yield this.service.createDiscipline({
                name,
                description: description || "",
                category_id,
            });
            res.status(201).json({ message: "Discipline created successfully", discipline });
        });
        /**
         * Finds a discipline by ID
         */
        this.getDisciplineById = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { params } = this.schemas.getDisciplineById.parse(req);
            const { id } = params;
            const discipline = yield this.service.getDisciplineById(id);
            res.status(200).json(discipline);
        });
        /**
         * Lists all disciplines
         */
        this.listDisciplines = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { query } = this.schemas.listDisciplines.parse(req);
            const disciplines = yield this.service.listDisciplines(query);
            res.status(200).json(disciplines);
        });
        /**
         * Updates a discipline by ID
         */
        this.updateDiscipline = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { body, params } = this.schemas.updateDiscipline.parse(req);
            const discipline = yield this.service.updateDisciplineById({
                id: params.id,
                data: body
            });
            res.status(200).json({ message: "Discipline updated successfully", discipline });
        });
        /**
         * Deletes a discipline by ID
         */
        this.deleteDiscipline = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { params } = this.schemas.getDisciplineById.parse(req);
            const discipline = yield this.service.deleteDisciplineById(params.id);
            res.status(200).json({ message: "Discipline deleted successfully", discipline });
        });
        this.service = service;
        this.schemas = schemas;
    }
}
exports.DisciplineController = DisciplineController;
