"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Discipline = void 0;
class Discipline {
    constructor(discipline) {
        Discipline.validateRequiredFields(discipline);
        this.name = discipline.name;
        this.description = discipline.description;
        this.category_id = discipline.category_id;
    }
    static validateRequiredFields(discipline) {
        const fields = [
            'name',
            'description',
            'category_id',
        ];
        for (const field of fields) {
            if (!discipline[field]) {
                throw new AppError(`Missing required field: ${field}`, 400);
            }
        }
    }
}
exports.Discipline = Discipline;
