"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DisciplineService = void 0;
const discipline_entity_1 = require("./discipline.entity");
/**
 * Service responsible for business logic related to Disciplines.
 * Handles creation, retrieval, update, and deletion of disciplines.
 */
class DisciplineService {
    constructor({ repository }) {
        /**
         * Creates a new discipline
         * @param discipline - Data for discipline creation
         * @returns The created discipline
         */
        this.createDiscipline = (discipline) => __awaiter(this, void 0, void 0, function* () {
            const newDiscipline = new discipline_entity_1.Discipline(discipline);
            const exist = yield this.repository.findDisciplineByName(discipline.name);
            if (exist)
                throw new AppError('Discipline with name already exist', 400);
            const category = yield this.getCategoryById(discipline.category_id);
            if (!category)
                throw new AppError('Category with name not found', 404);
            return yield this.repository.createDiscipline(newDiscipline);
        });
        /**
         * Finds a discipline by ID
         * @param id - Discipline ID
         * @returns The found discipline or throws error if not found
         */
        this.getDisciplineById = (id) => __awaiter(this, void 0, void 0, function* () {
            const discipline = yield this.repository.findDisciplineById(id);
            if (!discipline)
                throw new AppError('Discipline not found', 404);
            return discipline;
        });
        /**
         * Lists disciplines according to filter
         * @param filter - Search filter
         * @returns Array of found disciplines
         */
        this.listDisciplines = (...args_1) => __awaiter(this, [...args_1], void 0, function* (filter = {}) {
            /*
             * Correctly configure the filter
            */
            return yield this.repository.listDisciplines(filter);
        });
        /**
         * Updates a discipline by ID
         * @param params - Update parameters (id and data)
         * @returns The updated discipline
         */
        this.updateDisciplineById = (params) => __awaiter(this, void 0, void 0, function* () {
            const oldDiscipline = yield this.repository.findDisciplineById(params.id);
            if (!oldDiscipline)
                throw new AppError('Discipline not found', 404);
            const discipline = new discipline_entity_1.Discipline(Object.assign(Object.assign({}, oldDiscipline), params.data));
            if (params.data.name) {
                const exist = yield this.repository.findDisciplineByName(params.data.name);
                if (exist)
                    throw new AppError('Discipline with name already exist', 400);
            }
            if (params.data.category_id) {
                const category = yield this.getCategoryById(params.data.category_id);
                if (!category)
                    throw new AppError('Category with name not found', 404);
            }
            return yield this.repository.updateDisciplineById(params.id, discipline);
        });
        /**
         * Deletes a discipline by ID
         * @param id - Discipline ID
         * @returns The deleted discipline
         */
        this.deleteDisciplineById = (id) => __awaiter(this, void 0, void 0, function* () {
            const discipline = yield this.repository.findDisciplineById(id);
            if (!discipline)
                throw new AppError('Discipline not found', 404);
            return yield this.repository.deleteDisciplineById(id);
        });
        this.repository = repository;
    }
}
exports.DisciplineService = DisciplineService;
