"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RoleController = void 0;
/**
 * Controller responsible for handling Role-related HTTP requests.
 * Provides endpoints for creating, retrieving, updating, and deleting roles.
 */
class RoleController {
    constructor(roleService, roleSchema) {
        /**
         * Create a new role
         */
        this.createRole = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { body } = this.roleSchemas.createRole.parse(req);
            const { name, description } = body;
            const role = yield this.roleService.createRole({ name, description });
            res.status(201).json({ message: 'Role created successfully', role });
        });
        /**
         * List all roles
         */
        this.getRoles = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const roles = yield this.roleService.listRoles({});
            res.status(200).json(roles);
        });
        /**
         * Fetch a role by its ID
         */
        this.getRoleById = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { params } = this.roleSchemas.getRoleById.parse(req);
            const role = yield this.roleService.findRoleById(params.id);
            res.status(200).json(role);
        });
        /**
         * Update an existing role
         */
        this.updateRole = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { body, params } = this.roleSchemas.updateRole.parse(req);
            const { name, description } = body;
            const role = yield this.roleService.updateRole({
                id: params.id,
                data: {
                    name,
                    description
                }
            });
            res.status(200).json({ message: 'Role updated sucessfully', role });
        });
        /**
         * Delete a role by its ID
         */
        this.deleteRole = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { params } = this.roleSchemas.deleteRoleById.parse(req);
            const role = yield this.roleService.deleteRole(params.id);
            res.status(200).json({ message: 'Role deleted sucessfully', role });
        });
        this.roleService = roleService;
        this.roleSchemas = roleSchema;
    }
}
exports.RoleController = RoleController;
