"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Role = void 0;
/**
 * Role entity representing a role in the system.
 * Contains basic information such as name and description.
 */
class Role {
    constructor(role) {
        Role.validateRequiredFields(role);
        this.name = role.name;
        this.description = role.description;
    }
    static validateRequiredFields(role) {
        const fields = [
            'name',
            'description'
        ];
        for (const field of fields) {
            if (!role[field]) {
                throw new AppError(`Missing required field ${field}`, 400);
            }
        }
    }
}
exports.Role = Role;
