"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.adaptStudentForAuth = adaptStudentForAuth;
exports.adaptAuthStudentToStudent = adaptAuthStudentToStudent;
/**
 * Function to convert IStudent to IStudentAuthAdapter
 * @param student - Student data
 * @returns Data adapted for authentication
 */
function adaptStudentForAuth(student) {
    return {
        id: student.id,
        email: student.email,
        password: student.password,
        full_name: student.full_name,
        birth_date: student.birth_date,
        gender: student.gender,
        cpf: student.cpf,
        rg: student.rg,
        telephone: student.telephone,
        academic: student.academic,
        class_preferences: student.class_preferences,
        ranking: student.ranking,
        total_classes: student.total_classes,
        guardian: student.guardian,
        financial: student.financial,
        password_reset: student.password_reset,
        created_at: student.created_at,
        updated_at: student.updated_at,
    };
}
/**
 * Function to convert IStudentAuthAdapter to IStudent
 * @param authStudent - Authenticated student data
 * @returns Student data
 */
function adaptAuthStudentToStudent(authStudent) {
    return {
        id: authStudent.id,
        full_name: authStudent.full_name,
        birth_date: authStudent.birth_date,
        gender: authStudent.gender,
        cpf: authStudent.cpf,
        rg: authStudent.rg,
        email: authStudent.email,
        password: authStudent.password,
        ranking: authStudent.ranking,
        total_classes: authStudent.total_classes,
        telephone: authStudent.telephone,
        academic: authStudent.academic,
        class_preferences: authStudent.class_preferences,
        guardian: authStudent.guardian,
        financial: authStudent.financial,
        password_reset: authStudent.password_reset,
        created_at: authStudent.created_at,
        updated_at: authStudent.updated_at,
    };
}
