"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StudentController = void 0;
/**
 * Controller responsible for handling student-related HTTP requests.
 * Provides endpoints for creating, retrieving, updating, and deleting students.
 */
class StudentController {
    constructor(service, schemas) {
        /**
         * Creates a new student
         */
        this.createStudent = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { body } = this.schemas.createStudent.parse(req);
            const student = yield this.service.createStudent(body);
            res.status(201).json({ message: "Student created successfully", student });
        });
        /**
         * Finds a student by ID
         */
        this.getStudentById = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { id } = this.schemas.getStudentById.parse(req).params;
            const student = yield this.service.getStudentById(id);
            res.status(200).json(student);
        });
        /**
         * Lists all students
         */
        this.listStudents = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const students = yield this.service.listStudents();
            res.status(200).json(students);
        });
        /**
         * List students with adaptor
         */
        this.listAdaptedStudents = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { query } = this.schemas.listAdaptedStudents.parse(req);
            const students = yield this.service.listAdaptedStudents(query);
            res.status(200).json(students);
        });
        /**
         * Updates a student by ID
         */
        this.updateStudent = (req, res) => __awaiter(this, void 0, void 0, function* () {
            var _a;
            const { body } = this.schemas.updateStudent.parse(req);
            const student = yield this.service.updateStudent({
                // Ensures that the user only updates their own data
                id: (_a = req.user) === null || _a === void 0 ? void 0 : _a.id,
                data: body,
            });
            res.status(200).json({ message: "Student updated successfully", student });
        });
        /**
         * Deletes a student by ID
         */
        this.deleteStudent = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { id } = req.params;
            const student = yield this.service.deleteStudent(id);
            res.status(200).json({ message: "Student deleted successfully", student });
        });
        /**
         * Find teachers for students
         */
        this.getTeachers = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { days_of_week, start_time, end_time, discipline_id, } = this.schemas.getTeachers.parse(req).query;
            const teachers = yield this.service.getTeachers({
                daysOfWeek: days_of_week,
                startMinutes: start_time,
                endMinutes: end_time,
                disciplineId: discipline_id,
            });
            res.status(200).json({ teachers });
        });
        /**
         * Create scheduled class
         */
        this.createClass = (req, res) => __awaiter(this, void 0, void 0, function* () {
            var _a;
            // ensures that the student schedules classes only for themselves
            req.body.main_student_id = (_a = req.user) === null || _a === void 0 ? void 0 : _a.id;
            const { body } = this.schemas.createClass.parse(req);
            const createdClass = yield this.service.createClass(body);
            res.status(200).json({ message: "Scheduled class successfully", class: createdClass });
        });
        /**
         * List all student's classes
         */
        this.getClasses = (req, res) => __awaiter(this, void 0, void 0, function* () {
            var _a;
            // Ensures that the student only sees their own classes
            req.query.student_id = (_a = req.user) === null || _a === void 0 ? void 0 : _a.id;
            const { query } = this.schemas.getClasses.parse(req);
            const classes = yield this.service.listClasses(query);
            res.status(200).json(classes);
        });
        /**
         * Find one class by ID
         */
        this.getClassById = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { params } = this.schemas.getClassById.parse(req);
            const classFound = yield this.service.getClassById(params.id);
            res.status(200).json({ class: classFound });
        });
        /**
         * Update a class by ID
         */
        this.updateClass = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { body, params } = this.schemas.updateClass.parse(req);
            const newClass = yield this.service.updateClass({
                id: params.id,
                data: body,
            });
            res.status(200).json({ message: "Class schedule updated successfully", class: newClass });
        });
        /**
         * Cancel class by ID
         */
        this.cancelClass = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { params } = this.schemas.getClassById.parse(req);
            const canceledClass = yield this.service.cancelClass(params.id);
            res.status(200).json({ message: "Class cancelled successfully", class: canceledClass });
        });
        this.service = service;
        this.schemas = schemas;
    }
}
exports.StudentController = StudentController;
