"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.adaptTeacherForAuth = adaptTeacherForAuth;
exports.adaptAuthTeacherToTeacher = adaptAuthTeacherToTeacher;
/**
 * Function to convert ITeacher to ITeacherAuthAdapter
 * @param teacher - Teacher data
 * @returns Data adapted for authentication
 */
function adaptTeacherForAuth(teacher) {
    return {
        id: teacher.id,
        email: teacher.email,
        password: teacher.password,
        password_reset: teacher.password_reset,
        full_name: teacher.full_name,
        cpfCnpj: teacher.cpfCnpj,
        rg: teacher.rg,
        telephone: teacher.telephone,
        birth_date: teacher.birth_date,
        image_profile: teacher.image_profile,
        address: teacher.address,
        education: teacher.education,
        availability: teacher.availability,
        payment: teacher.payment,
        preferences: teacher.preferences,
        created_at: teacher.created_at,
        updated_at: teacher.updated_at,
    };
}
/**
 * Function to convert ITeacherAuthAdapter to ITeacher
 * @param authTeacher - Authenticated teacher data
 * @returns Teacher data
 */
function adaptAuthTeacherToTeacher(authTeacher) {
    return {
        id: authTeacher.id,
        full_name: authTeacher.full_name,
        cpfCnpj: authTeacher.cpfCnpj,
        rg: authTeacher.rg,
        email: authTeacher.email,
        password: authTeacher.password,
        telephone: authTeacher.telephone,
        birth_date: authTeacher.birth_date,
        image_profile: authTeacher.image_profile,
        address: authTeacher.address,
        education: authTeacher.education,
        availability: authTeacher.availability,
        payment: authTeacher.payment,
        preferences: authTeacher.preferences,
        password_reset: authTeacher.password_reset,
        created_at: authTeacher.created_at,
        updated_at: authTeacher.updated_at,
    };
}
