"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TeacherController = void 0;
/**
 * Controller responsible for handling teacher-related HTTP requests.
 * Provides endpoints for creating, retrieving, updating, and deleting teachers.
 */
class TeacherController {
    constructor(service, schemas) {
        /**
         * Create a new teacher
         */
        this.createTeacher = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { body } = this.schemas.createTeacher.parse(req);
            const newTeacher = yield this.service.createTeacher(body);
            res.status(201).json({ message: "Teacher created successfully", newTeacher });
        });
        /**
         * Fetch a teacher by ID
         */
        this.getTeacherById = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { params } = this.schemas.getTeacherById.parse(req);
            const teacher = yield this.service.getTeacherById(params.id);
            res.status(200).json(teacher);
        });
        /**
         * List all teachers
         */
        this.listTeachers = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const teachers = yield this.service.listTeacher();
            res.status(200).json(teachers);
        });
        /**
         * Update a teacher by ID
         */
        this.updateTeacher = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { params, body } = this.schemas.updateTeacher.parse(req);
            const teacher = yield this.service.updateTeacherById({
                id: params.id,
                data: body,
            });
            res.status(200).json({ message: "Teacher updated successfully", teacher });
        });
        /**
         * Delete a teacher by ID
         */
        this.deleteTeacher = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { params } = this.schemas.getTeacherById.parse(req);
            const teacher = yield this.service.deleteTeacherById(params.id);
            res.status(200).json({ message: "Teacher deleted successfully", teacher });
        });
        /**
         * Get all the teacher's classes
         */
        this.getClasses = (req, res) => __awaiter(this, void 0, void 0, function* () {
            var _a;
            req.query.teacher_id = (_a = req.user) === null || _a === void 0 ? void 0 : _a.id; // apply the id in query
            const { query } = this.schemas.getClasses.parse(req);
            const classes = yield this.service.listClasses(query);
            res.status(200).json(classes);
        });
        /**
         * Get one class by ID
         */
        this.getClassById = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { params } = this.schemas.getClassById.parse(req);
            const classFound = yield this.service.getClassById(params.id);
            res.status(200).json({ class: classFound });
        });
        /**
         * Finish a class by ID
         */
        this.finishClass = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { params } = this.schemas.getClassById.parse(req);
            const classFinished = yield this.service.finishClass(params.id);
            res.status(200).json({ message: "Class completed successfully", class: classFinished });
        });
        this.service = service;
        this.schemas = schemas;
    }
}
exports.TeacherController = TeacherController;
