"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TopicController = void 0;
/**
 * Controller responsible for handling topic-related HTTP requests.
 * Provides endpoints for creating, retrieving, updating, and deleting topics.
 */
class TopicController {
    constructor(service, schemas) {
        /**
         * Creates a new topic
         */
        this.createTopic = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { body } = this.schemas.createTopic.parse(req);
            const { name, description, level, discipline_id } = body;
            const topic = yield this.service.createTopic({
                name,
                description: description || "",
                level,
                discipline_id,
            });
            res.status(201).json({ message: "Topic created successfully", topic });
        });
        /**
         * Finds a topic by ID
         */
        this.getTopicById = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { params } = this.schemas.getTopic.parse(req);
            const topic = yield this.service.getTopicById(params.id);
            res.status(200).json(topic);
        });
        /**
         * Lists all topics
         */
        this.listTopics = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { query } = this.schemas.listTopics.parse(req);
            const topics = yield this.service.listTopics(query);
            res.status(200).json(topics);
        });
        /**
         * Updates a topic by ID
         */
        this.updateTopic = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { params, body } = this.schemas.updateTopic.parse(req);
            const topic = yield this.service.updateTopicById({
                id: params.id,
                data: body
            });
            res.status(200).json({ message: "Topic updated successfully", topic });
        });
        /**
         * Deletes a topic by ID
         */
        this.deleteTopic = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { params } = this.schemas.deleteTopic.parse(req);
            const topic = yield this.service.deleteTopicById(params.id);
            res.status(200).json({ message: "Topic deleted successfully", topic });
        });
        this.service = service;
        this.schemas = schemas;
    }
}
exports.TopicController = TopicController;
