"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Topic = void 0;
class Topic {
    constructor(topic) {
        Topic.validateRequiredFields(topic);
        this.name = topic.name;
        this.description = topic.description;
        this.level = topic.level;
        this.discipline_id = topic.discipline_id;
    }
    static validateRequiredFields(topic) {
        const fields = [
            'name',
            'description',
            'level',
            'discipline_id',
        ];
        for (const field of fields) {
            if (!topic[field]) {
                throw new AppError(`Missing required field: ${field}`, 400);
            }
        }
    }
}
exports.Topic = Topic;
