"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TopicService = void 0;
const topic_entity_1 = require("./topic.entity");
/**
 * Service responsible for business logic related to Topics.
 * Handles creation, retrieval, update, and deletion of topics.
 */
class TopicService {
    constructor({ repository }) {
        /**
         * Creates a new topic
         * @param topic - Data for topic creation
         * @returns The created topic
         */
        this.createTopic = (topic) => __awaiter(this, void 0, void 0, function* () {
            const newTopic = new topic_entity_1.Topic(topic);
            const exist = yield this.repository.findTopicByName(topic.name);
            if (exist)
                throw new AppError('Topic with name already exist', 400);
            const discipline = yield this.getDisciplineById(topic.discipline_id);
            if (!discipline)
                throw new AppError('Discipline invalid', 400);
            return yield this.repository.createTopic(newTopic);
        });
        /**
         * Finds a topic by ID
         * @param id - Topic ID
         * @returns The found topic or throws error if not found
         */
        this.getTopicById = (id) => __awaiter(this, void 0, void 0, function* () {
            const topic = yield this.repository.findTopicById(id);
            if (!topic)
                throw new AppError('Topic not found', 404);
            return topic;
        });
        /**
         * Lists topics according to filter
         * @param filter - Search filter
         * @returns Array of found topics
         */
        this.listTopics = (filter) => __awaiter(this, void 0, void 0, function* () {
            /*
             * Correctly configure the filter
            */
            return yield this.repository.listTopics(filter || {});
        });
        /**
         * Updates a topic by ID
         * @param params - Update parameters (id and data)
         * @returns The updated topic
         */
        this.updateTopicById = (params) => __awaiter(this, void 0, void 0, function* () {
            const oldTopic = yield this.repository.findTopicById(params.id);
            if (!oldTopic)
                throw new AppError('Topic not found', 404);
            const topic = new topic_entity_1.Topic(Object.assign(Object.assign({}, oldTopic), params.data));
            if (params.data.name) {
                const exist = yield this.repository.findTopicByName(params.data.name);
                if (exist)
                    throw new AppError('Topic with name already exist', 400);
            }
            if (params.data.discipline_id) {
                const discipline = yield this.getDisciplineById(params.data.discipline_id);
                if (!discipline)
                    throw new AppError('Discipline invalid', 400);
            }
            return yield this.repository.updateTopicById(params.id, topic);
        });
        /**
         * Deletes a topic by ID
         * @param id - Topic ID
         * @returns The deleted topic
         */
        this.deleteTopicById = (id) => __awaiter(this, void 0, void 0, function* () {
            const topic = yield this.repository.findTopicById(id);
            if (!topic)
                throw new AppError('Topic not found', 404);
            return yield this.repository.deleteTopicById(id);
        });
        this.repository = repository;
    }
}
exports.TopicService = TopicService;
