"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserController = void 0;
/**
 * Controller responsible for handling user-related HTTP requests.
 * Provides endpoints for creating, retrieving, updating, and deleting users.
 */
class UserController {
    constructor(service, schemas) {
        /**
         * Fetch all users
         */
        this.getUsers = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const users = yield this.service.listUsers({});
            res.status(200).json(users);
        });
        /**
         * Fetch a user by ID
         */
        this.getUserById = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { params } = this.schemas.getUserById.parse(req);
            const user = yield this.service.getUserById(params.id);
            res.status(200).json(user);
        });
        /**
         * Get the user roles
         */
        this.getUserRolesById = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { params } = this.schemas.getUserRolesById.parse(req);
            const userRoles = yield this.service.getRolesFromUserById(params.id);
            res.status(200).json(userRoles);
        });
        /**
         * Create a new user
         */
        this.createUser = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { body } = this.schemas.createUser.parse(req);
            const { name, email, password } = body;
            const user = yield this.service.createUser({
                name,
                email,
                password,
            });
            res.status(201).json({ message: "User created successfully", user });
        });
        /**
         * Assign one or more role to a user
         */
        this.assignRoleToUser = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { params, body } = this.schemas.assignRoleToUser.parse(req);
            const user = yield this.service.assignRoleToUser(params.id, body.rolesIds);
            res.status(200).json({ message: "Role assigned to user successfully", user });
        });
        /**
         * Update a user's information by ID
         */
        this.updateUser = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { params, body } = this.schemas.updateUser.parse(req);
            const user = yield this.service.updateUserById({
                id: params.id,
                userData: body
            });
            res.status(200).json({ message: "User updated successfully", user });
        });
        /**
         * Remove one or more roles from user
         */
        this.removeRoleFromUser = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { params, body } = this.schemas.removeRoleFromUser.parse(req);
            const user = yield this.service.removeRoleFromUserById(params.id, body.rolesIds);
            res.status(200).json({ message: "User role removed successfully", user });
        });
        /**
         * Delete a user by ID
         */
        this.deleteUser = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { params } = this.schemas.deleteUser.parse(req);
            const user = yield this.service.deleteUserById(params.id);
            res.status(200).json({ message: 'User deleted successfully', user });
        });
        this.createStudent = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { body } = this.schemas.createStudent.parse(req);
            const student = yield this.service.createStudent(body);
            res.status(201).json({ message: 'Student created successfully', student });
        });
        this.getStudentById = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { params } = this.schemas.getStudentById.parse(req);
            const student = yield this.service.getStudentById(params.id);
            res.status(200).json({ student });
        });
        this.listStudents = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { query } = this.schemas.listAdaptedStudents.parse(req);
            const students = yield this.service.listStudents(query);
            res.status(200).json({ students });
        });
        this.updateStudent = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { body, params } = this.schemas.updateStudent.parse(req);
            const student = yield this.service.updateStudent({
                id: params.id,
                data: body,
            });
            res.status(200).json({ message: 'Student updated successfully', student });
        });
        this.deleteStudent = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { params } = this.schemas.deleteStudent.parse(req);
            const student = yield this.service.deleteStudent(params.id);
            res.status(200).json({ message: 'Student deleted successfully', student });
        });
        this.createTeacher = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { body } = this.schemas.createTeacher.parse(req);
            const teacher = yield this.service.createTeacher(body);
            res.status(201).json({ message: 'Teacher created successfully', teacher });
        });
        this.getTeacherById = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { params } = this.schemas.getTeacherById.parse(req);
            const teacher = yield this.service.getTeacherById(params.id);
            res.status(200).json({ teacher });
        });
        this.listTeachers = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { query } = this.schemas.getTeachers.parse(req);
            const teachers = yield this.service.listTeachers(query);
            res.status(200).json({ teachers });
        });
        this.updateTeacher = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { body, params } = this.schemas.updateTeacher.parse(req);
            const student = yield this.service.updateTeacher({
                id: params.id,
                data: body,
            });
            res.status(200).json({ message: 'Teacher updated successfully', student });
        });
        this.deleteTeacher = (req, res) => __awaiter(this, void 0, void 0, function* () {
            const { params } = this.schemas.deleteTeacher.parse(req);
            const student = yield this.service.deleteTeacher(params.id);
            res.status(200).json({ message: 'Teacher deleted successfully', student });
        });
        this.service = service;
        this.schemas = schemas;
    }
}
exports.UserController = UserController;
