"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateAuthMiddleware = CreateAuthMiddleware;
/**
 * Generic authentication middleware that can work with any authenticatable entity
 * @template T - Type of entity that extends IAuthenticatableEntity
 * @template R - Type of registration parameters that extends IRegisterParams
 * @param authService - Generic authentication service
 * @returns Authentication middleware
 */
function CreateAuthMiddleware(authService) {
    return (req, res, next) => __awaiter(this, void 0, void 0, function* () {
        // Extract the header data
        const authHeader = req.headers.authorization;
        if (!authHeader)
            throw new AppError('No authorization header provided', 401);
        // Extract token from Authorization bearer
        const token = authHeader.split(' ')[1];
        if (!token)
            throw new AppError('Invalid token', 401);
        // Verify token
        const user = yield authService.verifyToken(token);
        if (!user)
            throw new AppError('Invalid token', 401);
        // Attach user information to request object
        req.user = user;
        next();
    });
}
