"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreatePermissionsMiddleware = CreatePermissionsMiddleware;
function CreatePermissionsMiddleware(roleService) {
    return (req, res, next) => __awaiter(this, void 0, void 0, function* () {
        const user = req.user;
        if (!user || !user.roles || user.roles.length === 0) {
            // If user has no roles, they have no permissions
            throw new AppError('User without roles', 403);
        }
        // Create an array of promises to fetch roles in parallel
        const rolesPromises = user.roles.map((roleId) => __awaiter(this, void 0, void 0, function* () {
            return yield roleService.findRoleById(roleId);
        }));
        // Wait for the resolution of all promises, returning only valid ones
        const roles = (yield Promise.all(rolesPromises)).filter(Boolean);
        if (roles.length === 0) {
            throw new AppError('User without roles', 403);
        }
        /**
         * Check user roles for each function
        **/
        next();
    });
}
