"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.JwtService = void 0;
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
class JwtService {
    constructor() {
        this.secretKey = process.env.JWT_SECRET;
        this.expiresIn = process.env.JWT_EXPIRES_IN;
        if (!this.secretKey || !this.expiresIn) {
            throw new AppError('Environment variables not found', 500);
        }
    }
    /**
     * Generate a JWT token
     * @param payload - The payload to include in the token
     * @returns The generated JWT token
     */
    generateToken(payload) {
        // Generate JWT token and return
        return jsonwebtoken_1.default.sign(payload, this.secretKey, {
            expiresIn: this.expiresIn
        });
    }
    /**
     * Verify a JWT token
     * @param token - The JWT token to verify
     * @returns The decoded data payload or null if verification fails
     */
    verifyToken(token) {
        try {
            return jsonwebtoken_1.default.verify(token, this.secretKey);
        }
        catch (err) {
            if (err instanceof jsonwebtoken_1.default.TokenExpiredError)
                throw new AppError('Invalid token', 401);
        }
    }
}
exports.JwtService = JwtService;
