"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MailtrapService = void 0;
const mailtrap_1 = require("mailtrap");
class MailtrapService {
    constructor() {
        this.token = process.env.MAILTRAP_TOKEN;
        this.senderEmail = process.env.MAILTRAP_SENDER_EMAIL;
        this.senderName = process.env.MAILTRAP_SENDER_NAME;
        if (!this.token || !this.senderEmail || !this.senderName) {
            throw new AppError('Environment variables not found', 500);
        }
        // Configure the mailtrap client with a token
        this.client = new mailtrap_1.MailtrapClient({ token: this.token });
    }
    /**
     * Send a email
     */
    sendOneMail(content) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                yield this.client.send({
                    from: {
                        email: this.senderEmail,
                        name: this.senderName,
                    },
                    to: [{ email: content.recipient }],
                    subject: content.subject,
                    text: content.text,
                });
            }
            catch (error) {
                throw new AppError(`Error sending email: ${error.message}`, 500);
            }
        });
    }
}
exports.MailtrapService = MailtrapService;
