"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SwaggerService = void 0;
const OpenApiValidator = __importStar(require("express-openapi-validator"));
const swagger_ui_express_1 = __importDefault(require("swagger-ui-express"));
const path_1 = __importDefault(require("path"));
const fs = __importStar(require("fs"));
const yaml = __importStar(require("js-yaml"));
class SwaggerService {
    constructor(app, basePath) {
        this.app = app;
        this.basePath = basePath;
        this.swaggerSpec = this.generateSwaggerSpec();
    }
    /**
     * Configure the Swagger validator router
     */
    swaggerValidator() {
        if (`${process.env.CONFIGURE_OPENAPI_VALIDATOR}` === 'true') {
            this.app.use(OpenApiValidator.middleware({
                apiSpec: this.swaggerSpec,
                validateRequests: true,
                validateResponses: false,
            }));
        }
    }
    /**
     * Configure the serve Swagger UI docs
     */
    setupSwaggerWebDocs() {
        this.app.use(`${this.basePath}/docs`, swagger_ui_express_1.default.serve, swagger_ui_express_1.default.setup(this.swaggerSpec));
    }
    /**
     * Middleware for validation error
     */
    getErrorHandler() {
        return (err, req, res, next) => {
            if (err.errors) {
                res.status(400).json({
                    message: err.message,
                    errors: err.errors,
                });
                return;
            }
            next(err);
        };
    }
    /**
     * Generate the Spec with doc files
     * @returns - Document OpenAPI configured
     */
    generateSwaggerSpec() {
        const docsDir = path_1.default.resolve(__dirname, '../../docs/');
        const allFiles = this.findYamlFilesRecursive(docsDir);
        const componentFiles = [];
        const pathFiles = [];
        for (const file of allFiles) {
            if (file.endsWith('.component.yaml')) {
                componentFiles.push(file);
            }
            else if (file.endsWith('.yaml')) {
                pathFiles.push(file);
            }
        }
        const merged = {
            openapi: '3.0.2',
            info: {},
            paths: {},
            components: {
                schemas: {},
                responses: {},
                parameters: {},
                securitySchemes: {}
            }
        };
        // Set API info from environment variables
        merged.info = {
            title: `${process.env.SWAGGER_API_TITLE}`,
            description: `${process.env.SWAGGER_API_DESCRIPTION}`,
            version: `${process.env.API_VERSION}`,
            contact: {
                name: `${process.env.SWAGGER_API_CONTACT_NAME}`,
                url: `${process.env.SWAGGER_API_CONTACT_URL}`,
                email: `${process.env.SWAGGER_API_CONTACT_EMAIL}`,
            },
            license: {
                name: `${process.env.SWAGGER_API_LICENSE_NAME}`,
                url: `${process.env.SWAGGER_API_LICENSE_URL}`,
            },
        };
        // Set the servers
        merged.servers = [
            {
                url: `${process.env.SWAGGER_API_SERVER_URL}${this.basePath}`,
                description: 'Default server'
            },
        ];
        // Merge the components
        for (const file of componentFiles) {
            const compDoc = yaml.load(fs.readFileSync(file, 'utf8'));
            // Deep merge in all components
            if (compDoc && compDoc.components) {
                if (compDoc.components.schemas) {
                    merged.components.schemas = Object.assign(Object.assign({}, merged.components.schemas), compDoc.components.schemas);
                }
                if (compDoc.components.responses) {
                    merged.components.responses = Object.assign(Object.assign({}, merged.components.responses), compDoc.components.responses);
                }
                if (compDoc.components.parameters) {
                    merged.components.parameters = Object.assign(Object.assign({}, merged.components.parameters), compDoc.components.parameters);
                }
                if (compDoc.components.securitySchemes) {
                    merged.components.securitySchemes = Object.assign(Object.assign({}, merged.components.securitySchemes), compDoc.components.securitySchemes);
                }
            }
        }
        // Merge all paths in YAML docs
        for (const file of pathFiles) {
            const doc = yaml.load(fs.readFileSync(file, 'utf8'));
            if (doc && doc.paths) {
                merged.paths = Object.assign(Object.assign({}, merged.paths), doc.paths);
            }
        }
        return merged;
    }
    /**
     * Recursively searches for all files ending with .yaml
     * starting from an initial directory.
     * Returns an array of absolute paths.
     */
    findYamlFilesRecursive(dir) {
        const allFiles = [];
        const items = fs.readdirSync(dir);
        for (const item of items) {
            const fullPath = path_1.default.join(dir, item);
            const stat = fs.statSync(fullPath);
            if (stat.isDirectory()) {
                // If it's a directory, call the function recursively
                // and add the found files to the array
                allFiles.push(...this.findYamlFilesRecursive(fullPath));
            }
            else if (stat.isFile() && fullPath.endsWith('.yaml')) {
                // If it's a .yaml file, add it to the array
                allFiles.push(fullPath);
            }
        }
        return allFiles;
    }
}
exports.SwaggerService = SwaggerService;
