"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MongooseDatabase = void 0;
const mongoose_1 = __importDefault(require("mongoose"));
const traceability_1 = require("traceability");
class MongooseDatabase {
    constructor(DB_URI, DB_NAME) {
        var _a, _b;
        this.DB_URI = DB_URI;
        this.DB_NAME = DB_NAME;
        (_a = mongoose_1.default.connection) === null || _a === void 0 ? void 0 : _a.once('open', () => {
            traceability_1.Logger.info('Connection Stablished - MongoDB');
        });
        (_b = mongoose_1.default.connection) === null || _b === void 0 ? void 0 : _b.on('error', (err) => {
            traceability_1.Logger.error(`Error to connect - MongoDB: Error: ${err.message}`);
        });
    }
    start() {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.DB_CONNECTION) {
                yield mongoose_1.default.connect(this.DB_URI, { dbName: this.DB_NAME });
                this.DB_CONNECTION = mongoose_1.default.connection;
            }
        });
    }
    close() {
        return __awaiter(this, void 0, void 0, function* () {
            var _a;
            (_a = this.DB_CONNECTION) === null || _a === void 0 ? void 0 : _a.close();
        });
    }
}
exports.MongooseDatabase = MongooseDatabase;
