const http = require('http');
const https = require('https');

// Usage: set URL like 'http://localhost:3000/api/v1/docs' via env URL
// or run as-is which defaults to http://localhost:3000/api/v1/docs
const baseUrl = process.env.URL || 'http://localhost:3000/api/v1/docs';
const specUrl = new URL(`${baseUrl.replace(/\/$/, '')}/spec.json`);

console.log('Checking spec URL:', specUrl.href);

const lib = specUrl.protocol === 'https:' ? https : http;

lib.get(specUrl, (res) => {
  console.log('STATUS', res.statusCode);
  res.setEncoding('utf8');
  let body = '';
  res.on('data', (chunk) => body += chunk);
  res.on('end', () => {
    console.log('BODY_START');
    try {
      const obj = JSON.parse(body);
      console.log('Parsed top-level keys:', Object.keys(obj));
      if (obj.openapi) {
        console.log('OK: found openapi =', obj.openapi);
        process.exit(0);
      }
      if (obj.swagger) {
        console.log('OK: found swagger =', obj.swagger);
        process.exit(0);
      }
      console.error('ERROR: spec JSON does not contain `openapi` or `swagger` field.');
      console.error('Top-level keys:', Object.keys(obj));
      process.exit(2);
    } catch (e) {
      console.error('ERROR: failed to parse JSON. The response may be HTML or invalid JSON.');
      console.error('Response (truncated):');
      console.error(body.slice(0, 2000));
      process.exit(3);
    }
  });
}).on('error', (e) => {
  console.error('ERR', e && e.message);
  if (e && e.stack) console.error(e.stack);
  try { console.error('ERROR OBJECT:', JSON.stringify(e, Object.getOwnPropertyNames(e), 2)); } catch (ex) {}
  process.exit(1);
});
