const fs = require('fs');
const path = require('path');

const srcDir = path.resolve(__dirname, '../src/shared/contracts');
const destDir = path.resolve(__dirname, '../dist/src/contracts');

try {
  if (!fs.existsSync(srcDir)) {
    console.log(`Source contracts directory not found: ${srcDir}`);
    process.exit(0);
  }

  fs.mkdirSync(destDir, { recursive: true });

  const files = fs.readdirSync(srcDir);
  const yamlFiles = files.filter(f => f.endsWith('.yaml'));

  yamlFiles.forEach(file => {
    const srcFile = path.join(srcDir, file);
    const destFile = path.join(destDir, file);
    fs.copyFileSync(srcFile, destFile);
    console.log(`Copied ${file} -> ${destFile}`);
  });

  if (yamlFiles.length === 0) {
    console.log('No .yaml files found to copy.');
  }
} catch (err) {
  console.error('Error copying contract files:', err);
  process.exit(1);
}
