const fs = require('fs');
const path = require('path');

const dir = path.join(__dirname, '..', 'node_modules', '@express-rate-limit', 'tsconfig');
const file = path.join(dir, 'tsconfig.json');
const content = {
  compilerOptions: {
    target: 'ES2020',
    module: 'CommonJS',
    lib: ['ES2020'],
    moduleResolution: 'node',
    esModuleInterop: true,
    skipLibCheck: true
  }
};

try {
  fs.mkdirSync(dir, { recursive: true });
  fs.writeFileSync(file, JSON.stringify(content, null, 2), 'utf8');
  console.log('WROTE', file);
} catch (e) {
  console.error('Failed to write', file, e);
  process.exit(1);
}
