const http = require('http');
const https = require('https');

const base = process.env.URL || 'http://localhost:3000/api/v1/docs';
const endpoints = ['','/spec.json','/init.js'].map(p => `${base.replace(/\/$/, '')}${p}`);

function fetchUrl(u) {
  return new Promise((resolve) => {
    try {
      const urlObj = new URL(u);
      const lib = urlObj.protocol === 'https:' ? https : http;
      const opts = { hostname: urlObj.hostname, port: urlObj.port, path: urlObj.pathname + urlObj.search, method: 'GET' };
      const req = lib.request(urlObj, (res) => {
        let body = '';
        res.setEncoding('utf8');
        res.on('data', (c) => body += c);
        res.on('end', () => {
          resolve({ url: u, status: res.statusCode, headers: res.headers, body: body.slice(0, 5000) });
        });
      });
      req.on('error', (e) => resolve({ url: u, error: String(e) }));
      req.end();
    } catch (e) {
      resolve({ url: u, error: String(e) });
    }
  });
}

(async () => {
  for (const e of endpoints) {
    console.log('\n--- FETCH', e);
    const r = await fetchUrl(e);
    if (r.error) {
      console.error('ERROR', r.error);
      continue;
    }
    console.log('STATUS', r.status);
    console.log('Content-Type:', r.headers['content-type']);
    console.log('BODY (truncated):\n', r.body);
  }
})();
