import path from 'path';
import { Server } from '../main/server';
import { Container } from '../main/factories/container';

const _OPEN_API_SPEC_FILE_LOCATION = path.resolve(
  __dirname,
  '../contracts/service.yaml',
);

export const app = new Server({
  basePath: `/api/${process.env.API_VERSION || 'v1'}`,
  port: Number(process.env.PORT) || 3000,
  routers: Container.initialize(),
  timeoutMilliseconds: 30000,
});
