import mongoose from 'mongoose';
import { MUser } from '../../infrastructure/database/models/user.model';
import { IUser } from '../../modules/user/interfaces/user.interface';
let paramsCreate: IUser;

beforeEach(async () => {
  paramsCreate = {
    id: new mongoose.Types.ObjectId().toHexString(),
    email: 'whitebeard@email.com',
    name: 'Whitebeard',
    password: 'pass123',
    roles: ['student'],
    created_at: new Date(),
  };
});

describe('When we try to create a valid user', () => {
  it('should return success when we try to create a valid user', async () => {
    const user = new MUser({
      _id: paramsCreate.id,
      name: paramsCreate.name,
      email: paramsCreate.email,
      password: paramsCreate.password,
      roles: paramsCreate.roles,
      created_at: paramsCreate.created_at,
    });

    await user.save();

    const userInDb = await MUser.findOne({ _id: paramsCreate.id }).lean();

    expect(userInDb).toBeDefined();
    expect(userInDb!._id).toBe(paramsCreate.id);
    expect(userInDb!.email).toBe(paramsCreate.email);
    expect(userInDb!.name).toBe(paramsCreate.name);
    expect(userInDb!.roles).toEqual(paramsCreate.roles);
  });
});
