import { Server } from "./main/server";
import { Container } from "./main/factories/container";

/**
 * Create the application with Server instance
 */
export const app = new Server({
    basePath: `/api/${process.env.API_VERSION}`,
    port: Number(process.env.PORT) || 3000,
    routers: Container.inicialize(),
    timeoutMilliseconds: 30000
});

/**
 * Start the server
 */
app.start();