import { IMCategory } from "../../../modules/Category/interfaces/category.interface";
import { baseSchemaDefinition, baseSchemaOptions } from "./shared/base.model";
import mongoose from "mongoose";

export const MCategory = mongoose.model<IMCategory>(
    'Category',
    new mongoose.Schema(
        {
            ...baseSchemaDefinition,
            name: {
                type: String,
                required: true,
                unique: true,
            },
            description: {
                type: String,
                required: true,
            }
        },
        baseSchemaOptions
    )
);