import { IMClass } from "../../../modules/Class/interfaces/class.interface";
import { baseSchemaDefinition, baseSchemaOptions } from "./shared/base.model";
import mongoose from "mongoose";

export const MClass = mongoose.model<IMClass>(
    'Class',
    new mongoose.Schema(
        {
            ...baseSchemaDefinition,
            name: {
                type: String,
                required: true,
            },
            main_student_id: {
                type: String,
                required: true,
            },
            teacher_id: {
                type: String,
                required: true,
            },
            topic_id: {
                type: String,
                required: true,
            },
            additional_students: {
                type: [String],
                required: false,
                default: [],
            },
            link: {
                type: String,
                required: false,
                default: "",
            },
            streaming_id: {
                type: String,
                required: false,
                default: "",
            },
            type: {
                type: String,
                required: true,
                enum: ['individual', 'group'],
            },
            start_time: {
                type: Date,
                required: true,
            },
            end_time: {
                type: Date,
                required: true,
            },
            status: {
                type: String,
                required: true,
                enum: ['scheduled', 'canceled', 'completed']
            },
            payment_status: {
                type: String,
                required: true,
                enum: ['pending', 'paid', 'refunded'],
            },
        },
        baseSchemaOptions
    )
);