import { IMDiscipline } from "../../../modules/Discipline/interfaces/discipline.interface";
import { baseSchemaDefinition, baseSchemaOptions } from "./shared/base.model";
import mongoose from "mongoose";

export const MDiscipline = mongoose.model<IMDiscipline>(
    'Discipline',
    new mongoose.Schema(
        {
            ...baseSchemaDefinition,
            name: {
                type: String,
                required: true,
                unique: true,
            },
            description: {
                type: String,
                required: true,
            },
            category_id: {
                type: String,
                required: true,
            }
        },
        baseSchemaOptions
    )
);