import { SchemaDefinition, SchemaOptions } from 'mongoose';
import { v7 as uuidv7 } from 'uuid';

/**
 * The base Schema with default proprieties from all Mongoose Schemas
 */
export const baseSchemaDefinition: SchemaDefinition = {
    _id: {
        type: String,
        default: () => uuidv7(),
    },
};

/**
 * Base options Schema with timestamp proprieties from all Mongoose Schemas
 */
export const baseSchemaOptions: SchemaOptions = {
    timestamps: {
        createdAt: 'created_at',
        updatedAt: 'updated_at',
    },
};
