import { baseSchemaDefinition, baseSchemaOptions } from './shared/base.model';
import { IMStudent } from '../../../modules/Student/interfaces/student.interface';
import mongoose from 'mongoose';

const AvaliableTimes = new mongoose.Schema({
    day_of_week: {
        type: Number,
        required: true,
    },
    start_time: {
        type: Number,
        required: true,
    },
    end_time: {
        type: Number,
        required: true,
    },
},
{
    _id: false,
});

export const MStudent = mongoose.model<IMStudent>(
    'Student',
    new mongoose.Schema({
        ...baseSchemaDefinition,
        full_name: {
            type: String,
            required: true,
        },
        birth_date: {
            type: Date,
            required: true,
        },
        gender: {
            type: String,
            required: false,
        },
        cpf: {
            value: {
                type: String,
                required: true,
            },
            upload_id: {
                type: mongoose.Types.ObjectId,
                reference: "Upload",
                required: false,
            },
        },
        rg: {
            value: {
                type: String,
                required: false,
            },
            upload_id: {
                type: mongoose.Types.ObjectId,
                reference: "Upload",
                required: false,
            },
        },
        email: {
            type: String,
            required: true,
            unique: true,
            match: [
                /^[^\s@]+@[^\s@]+\.[^\s@]+$/,
                'Please provide a valid email address'
            ],
        },
        password: {
            type: String,
            required: true,
        },
        password_reset: {
            token: { // code
                type: String,
                required: false,
                default: null,
            },
            expires_at: { // expires time
                type: Date,
                required: false,
                default: null,
            }
        },
        telephone: {
            type: String,
            required: true,
        },
        academic: {
            current_grade: {
                type: String,
                required: true
            },
            school: {
                type: String,
                required: false
            },
            subjects: {
                type: [String],
                required: true
            },
            difficulty_level: {
                type: String,
                required: true
            },
            main_goal: {
                type: String,
                required: true
            },
        },
        ranking: {
            type: Number,
            required: true
        },
        total_classes: {
            type: Number,
            required: true,
        },
        class_preferences: {
            frequency: {
                type: String,
                required: true
            },
            available_times: [AvaliableTimes],
            preferred_teacher: {
                type: String,
                required: false
            },
        },
        guardian: {
            full_name: {
                type: String,
                required: false
            },
            birth_date: {
                type: Date,
                required: false,
            },
            telephone: {
                type: String, 
                required: false
            },
            email: {
                type: String,
                required: false
            },
            relationship: {
                type: String,
                required: false
            },
            cpf: {
                value: {
                    type: String,
                    required: false,
                },
                upload_id: {
                    type: mongoose.Types.ObjectId,
                    reference: "Upload",
                    required: false,
                },
            },
            rg: {
                value: {
                    type: String,
                    required: false,
                },
                upload_id: {
                    type: mongoose.Types.ObjectId,
                    reference: "Upload",
                    required: false,
                },
            },
        },
        financial: {
            credit_card_registered: {
                type: Boolean,
                required: false
            },
            card_info: {
                cardholder_name: {
                    type: String,
                    required: false
                },
                card_number: {
                    type: String,
                    required: false
                },
                expiration: {
                    type: String,
                    required: false
                },
                cvv: {
                    type: String,
                    required: false
                },
            },
        },
    },
    baseSchemaOptions
));