import { baseSchemaDefinition, baseSchemaOptions } from "./shared/base.model";
import { IMTeacher } from "../../../modules/Teacher/interfaces/teacher.interface";
import mongoose from "mongoose";
import { addressSchema } from "./shared/addressSchema";
import { docsSchema } from "./shared/cpfSchema";
import { passwordResetSchema } from "./shared/passwordResetSchema";
import { availableTimesSchema } from "./shared/availableTimesSchema";
import { cpfCnpjSchema } from "./shared/cpfCnpjSchema";

// Sub document for education data
const educationSchema = new mongoose.Schema({
    level: {
        type: String,
        required: true,
    },
    field: {
        type: String,
        required: true,
    },
    teaching_experience: {
        type: String,
        required: true,
    },
    disciplines: {
        type: [String],
        required: true,
    },
    education_levels: {
        type: [String],
        required: true,
    },
},
{
    _id: false
});

// Sub document for avaliability data
const availabilitySchema = new mongoose.Schema({
    in_person_location: {
        type: [String],
        required: false,
    },
    available_times: [availableTimesSchema],
    accepts_emergency_classes: {
        type: Boolean,
        required: false,
    },
},
{
    _id: false
});

const paymentSchema = new mongoose.Schema({
    hourly_rate: {
        type: Number,
        required: true,
    },
    payment_info: {
        type: {
            type: String,
            required: true,
        },
        key: {
            type: String,
            required: true,
        },
    }
},
{
    _id: false
});

const preferencesSchema = new mongoose.Schema({
    student_type_preference: {
        type: String,
        required: false,
    },
    general_observations: {
        type: String,
        required: false,
    },
},
{
    _id: false
});

export const MTeacher = mongoose.model<IMTeacher>(
    'Teacher',
    new mongoose.Schema({
        ...baseSchemaDefinition,
        full_name: {
            type: String,
            required: true,
        },
        cpfCnpj: {
            type: cpfCnpjSchema,
            required: true,
        },
        rg: {
            type: docsSchema,
            required: false,
        },
        email: {
            type: String,
            required: true,
            unique: true,
            match: [
                /^[^\s@]+@[^\s@]+\.[^\s@]+$/,
                'Please provide a valid email address'
            ],
        },
        password: {
            type: String,
            required: true,
        },
        password_reset: {
            type: passwordResetSchema,
            required: false,
            default: null,
        },
        telephone: {
            type: String,
            required: true
        },
        birth_date: {
            type: Date,
            required: true
        },
        image_profile: {
            type: String,
            required: false,
        },
        address: {
            type: addressSchema,
            required: false,
            default: null,
        },
        education: {
            type: educationSchema,
            required: false,
            default: null
        },
        availability: {
            type: availabilitySchema,
            required: false,
            default: null
        },
        payment: {
            type: paymentSchema,
            required: false,
            default: null
        },
        preferences: {
            type: preferencesSchema,
            required: false,
            default: null
        },
    },
    baseSchemaOptions
));